local assets =
{
	Asset("ANIM", "anim/monstermetal.zip"),
    Asset("ATLAS", "images/inventoryimages/monstermetal.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("monstermetal")
    inst.AnimState:SetBuild("monstermetal")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "monstermetal"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/monstermetal.xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("monstermetal", fn, assets)